/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetEntryFamiliar;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.IOUtils;

public class PlayerFamiliars {
    public static PlayerFamiliars INSTANCE = new PlayerFamiliars();
    public Map<UUID, Map<UUID, PetEntry>> playerFamiliars = new HashMap<UUID, Map<UUID, PetEntry>>();
    public Map<UUID, Long> playerFamiliarLoadedTimes = new HashMap<UUID, Long>();
    public List<String> familiarBlacklist = new ArrayList<String>();
    public SSLContext sslContext;

    public PlayerFamiliars() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseFamiliarJSON(String jsonString) {
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject json = jsonParser.parse(jsonString).getAsJsonObject();
            JsonArray jsonArray = json.getAsJsonArray("data");
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                try {
                    JsonObject familiarJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    UUID minecraft_uuid = UUID.fromString(familiarJson.get("minecraft_uuid").getAsString());
                    if (this.familiarBlacklist.contains(minecraft_uuid.toString())) continue;
                    UUID familiar_uuid = UUID.fromString(familiarJson.get("familiar_uuid").getAsString());
                    String familiar_species = familiarJson.get("familiar_species").getAsString();
                    CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(familiar_species);
                    int familiar_subspecies = familiarJson.get("familiar_subspecies").getAsInt();
                    familiar_species = this.handleLegacySpecies(familiar_species);
                    int familiar_variant = familiarJson.get("familiar_variant").getAsInt();
                    Variant creatureVariant = creatureInfo != null ? creatureInfo.getSubspecies(familiar_subspecies).getVariant(familiar_variant) : null;
                    String familiar_name = familiarJson.get("familiar_name").getAsString();
                    String familiar_color = familiarJson.get("familiar_color").getAsString();
                    double familiar_size = familiarJson.get("familiar_size").getAsDouble();
                    if (familiar_size <= 0.0) {
                        familiar_size = 0.5;
                        if (creatureVariant != null && creatureVariant.scale != 1.0) {
                            familiar_size *= 1.0 / creatureVariant.scale;
                        }
                    }
                    PetEntryFamiliar familiarEntry = new PetEntryFamiliar(familiar_uuid, null, familiar_species.toLowerCase());
                    familiarEntry.setEntitySubspecies(familiar_subspecies);
                    familiarEntry.setEntityVariant(familiar_variant);
                    familiarEntry.setEntitySize(familiar_size);
                    if (!"".equals(familiar_name)) {
                        familiarEntry.setEntityName(familiar_name);
                    }
                    familiarEntry.setColor(familiar_color);
                    if (!this.playerFamiliars.containsKey(minecraft_uuid)) {
                        this.playerFamiliars.put(minecraft_uuid, new HashMap());
                    }
                    if (!this.playerFamiliars.get(minecraft_uuid).containsKey(familiar_uuid)) {
                        this.playerFamiliars.get(minecraft_uuid).put(familiar_uuid, familiarEntry);
                        continue;
                    }
                    PetEntry existingEntry = this.playerFamiliars.get(minecraft_uuid).get(familiar_uuid);
                    existingEntry.copy(familiarEntry);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<UUID, PetEntry> getFamiliarsForPlayer(EntityPlayer player) {
        long currentTime = System.currentTimeMillis() / 1000L;
        long loadedTime = this.getPlayerFamiliarLoadedTime(player);
        if (loadedTime < 0L || currentTime - loadedTime > 1800L) {
            this.updatePlayerFamiliarLoadedTime(player);
            FamiliarLoader familiarLoader = new FamiliarLoader(player);
            Thread thread = new Thread(familiarLoader);
            thread.start();
        }
        Map<UUID, PetEntry> playerFamiliarEntries = new HashMap<UUID, PetEntry>();
        if (this.playerFamiliars.containsKey(player.func_110124_au())) {
            playerFamiliarEntries = this.playerFamiliars.get(player.func_110124_au());
            for (PetEntry familiarEntry : playerFamiliarEntries.values()) {
                if (familiarEntry.host != null) continue;
                familiarEntry.host = player;
            }
        }
        return playerFamiliarEntries;
    }

    public long getPlayerFamiliarLoadedTime(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        if (!this.playerFamiliarLoadedTimes.containsKey(uuid)) {
            return -1L;
        }
        return this.playerFamiliarLoadedTimes.get(uuid);
    }

    public void updatePlayerFamiliarLoadedTime(EntityPlayer player) {
        this.playerFamiliarLoadedTimes.put(player.func_110124_au(), System.currentTimeMillis() / 1000L);
    }

    public String handleLegacySpecies(String species) {
        if (species.equalsIgnoreCase("apollyon")) {
            return "archvile";
        }
        if (species.equalsIgnoreCase("belphegor")) {
            return "belph";
        }
        if (species.equalsIgnoreCase("behemophet")) {
            return "behemoth";
        }
        if (species.equalsIgnoreCase("malwrath")) {
            return "cacodemon";
        }
        if (species.equalsIgnoreCase("naxiris")) {
            return "beholder";
        }
        if (species.equalsIgnoreCase("zephyr")) {
            return "djinn";
        }
        if (species.equalsIgnoreCase("raidra")) {
            return "zephyr";
        }
        if (species.equalsIgnoreCase("ningen")) {
            return "dweller";
        }
        if (species.equalsIgnoreCase("cherufe")) {
            return "lobber";
        }
        if (species.equalsIgnoreCase("ostimien")) {
            return "lurker";
        }
        if (species.equalsIgnoreCase("kathoga")) {
            return "pinky";
        }
        if (species.equalsIgnoreCase("brucha")) {
            return "quillbeast";
        }
        if (species.equalsIgnoreCase("stryder")) {
            return "strider";
        }
        if (species.equalsIgnoreCase("lycosa")) {
            return "tarantula";
        }
        if (species.equalsIgnoreCase("jouste")) {
            return "joust";
        }
        return species;
    }

    public static class FamiliarLoader
    implements Runnable {
        EntityPlayer player;

        public FamiliarLoader(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            this.getForPlayerUUID(this.player.func_110124_au());
            ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(this.player);
            if (extendedPlayer != null) {
                extendedPlayer.loadFamiliars();
            }
            INSTANCE.updatePlayerFamiliarLoadedTime(this.player);
        }

        private void getForPlayerUUID(UUID uuid) {
            String jsonString;
            try {
                URL url = new URL("https://service.lycanitesmobs.com/api/v1/familiars?minecraft_uuid=" + uuid.toString());
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setSSLSocketFactory(PlayerFamiliars.INSTANCE.sslContext.getSocketFactory());
                urlConnection.setRequestProperty("Authorization", "Bearer 7ed1f44cbc1aff693e604075f23d56402983a4a0");
                String osName = System.getProperty("os.name");
                urlConnection.setRequestProperty("User-Agent", "Minecraft 1.12.2 (" + osName + ") LycanitesMobs " + "2.0.8.9");
                try (InputStream inputStream = urlConnection.getInputStream();){
                    jsonString = IOUtils.toString((InputStream)inputStream, (Charset)null);
                }
                LycanitesMobs.logInfo("", "Online familiars loaded successfully for " + uuid + ".");
            }
            catch (Throwable e) {
                LycanitesMobs.logInfo("", "Unable to access the online familiars service.");
                e.printStackTrace();
                return;
            }
            INSTANCE.parseFamiliarJSON(jsonString);
        }
    }
}

